import { Member, BookTokenSubscription, PaginationParams, Book } from '.';
import { Package } from './package';

export interface QuotationBaseBody {
    id: string;
    subscriptionId: string;
    displayId: string;
    refNo: number;
    remarks: string | null;
    price: number;
    issueDate: string;
    createdAt: string;
}

export interface QuotationQuery extends PaginationParams {
    refNo?: string;
}

export type GenerateQuotationBody = Pick<QuotationBaseBody, 'issueDate' | 'remarks'>;

export type Quotation = Pick<QuotationBaseBody, 'id' | 'displayId' | 'issueDate' | 'createdAt' | 'price'>;

export type QuotationView = Omit<QuotationBaseBody, 'createdAt'> & {
    member: Pick<Member, 'fullName' | 'address' | 'phoneNumber'>;
    allPackage: Package[];
};

export interface BookQuotation {
    id: string;
    name: string;
    price: number;
}
