import { PaginationParams } from './pagination';

export enum PackageStatus {
    ACTIVE = 'ACTIVE',
    INACTIVE = 'INACTIVE',
}

export interface Package {
    id: string;
    name: string;
    price: number;
    numberOfBookToken: number;
    status: PackageStatus;
    description?: string;
    createdAt: string;
    updatedAt: string;
    deletedAt: string;
}

export interface PackageQuery extends PaginationParams {
    name: string;
    status: PackageStatus;
}

export interface PackageParams {
    name: string;
    price: number;
    numberOfBookToken: number;
    status: PackageStatus;
    description: string;
}
