import { useState } from 'react';
import { TableProps } from 'antd';
import { PaginationState, SortOrder, Sorter, UsePaginationParams } from '@/types';

const usePagination = <T = any>(init?: UsePaginationParams) => {
    const [pagination, setPagination] = useState<PaginationState>({
        page: 1,
        pageSize: 10,
        total: 0,
        sortOrder: SortOrder.DESC,
        sortField: 'createdAt',
        ...init,
    });

    const paginationOnChange: TableProps<T>['onChange'] = (tablePagination, filter, sorter) => {
        const sorting = sorter as unknown as Sorter;
        setPagination((prev) => {
            return {
                ...prev,
                page: tablePagination.current || 1,
                pageSize: tablePagination.pageSize || 10,
                sortField: sorting?.field ?? prev?.sortField,
                sortOrder: sorting.order == 'ascend' ? SortOrder.ASC : !sorting.order ? prev.sortOrder : SortOrder.DESC,
            };
        });
    };

    return [pagination, setPagination, paginationOnChange] as const;
};

export default usePagination;
