import { CloudDownloadOutlined } from '@ant-design/icons';
import { Button } from 'antd';
import { useTranslation } from 'next-i18next';
import ExcelJS from 'exceljs';

// PDF
interface ExportDataProps {
    fileName: string;
    getExportData: () => Promise<{ data: any }>;
}

const ExportData: React.FC<ExportDataProps> = ({ fileName, getExportData }) => {
    const { t } = useTranslation(['study-group', 'layout', 'common', 'messages']);

    const workbook = new ExcelJS.Workbook();
    const worksheet = workbook.addWorksheet('Study Group Task Comments');

    // Columns
    worksheet.columns = [
        { header: 'Full Name', key: 'fullName', width: 20 },
        { header: 'Preferred Name', key: 'preferredName', width: 20 },
        { header: 'Task Date', key: 'taskDate', width: 20 },
        { header: 'Comment', key: 'comment', width: 40 },
    ];

    // Add Row Style
    worksheet.getRow(1).font = { bold: true };
    worksheet.getRow(1).alignment = { horizontal: 'center' };
    worksheet.getRow(1).fill = {
        type: 'pattern',
        pattern: 'solid',
        fgColor: { argb: 'FFA9A9A9' },
    };

    const generateExcelHandler = async (data: any) => {
        data?.map((order: any) => {
            worksheet.addRow({
                fullName: order.fullName ?? '',
                preferredName: order.preferredName,
                taskDate: order.taskDate,
                comment: order.comment,
            });
        });

        // Generate the Excel file
        await workbook.xlsx.writeBuffer().then((buffer: any) => {
            const blob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
            const link = document.createElement('a');
            const url = URL.createObjectURL(blob);
            link.href = url;
            link.setAttribute('download', fileName);
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    };

    const exportToCsvHandler = () => {
        getExportData().then((res) => {
            generateExcelHandler(res.data);
        });
    };

    return (
        <Button type="primary" icon={<CloudDownloadOutlined />} onClick={exportToCsvHandler}>
            {t('export-csv')}
        </Button>
    );
};

export default ExportData;
