import RoleCheckbox, { RoleAction } from './Checkbox';

interface RoleContainerAttributes {
    roleName?: string;
    roleItem: RoleAction[];
}

const RoleContainer: React.FC<RoleContainerAttributes> = ({ roleName, roleItem }) => {
    return (
        <div className="flex flex-col mb-3">
            {roleName && <p className="m-0 mb-1 text-base font-semibold">{roleName}</p>}
            <div className="grid grid-cols-1 gap-4 xs:grid-cols-2 sm:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 2xl:grid-cols-6">
                {roleItem.map((item) => {
                    return (
                        <div key={item.actionName}>
                            <RoleCheckbox roleAction={item} />
                        </div>
                    );
                })}
            </div>
        </div>
    );
};

export default RoleContainer;
