export const currencyFormatter = (value: any) => {
    let formattedValue = new Intl.NumberFormat(undefined).format(value);

    const parts = formattedValue.split('.');
    if (parts.length === 1) {
        formattedValue += '.00';
    } else if (parts.length === 2 && parts[1].length === 1) {
        formattedValue += '0';
    }

    return formattedValue;
};

export const currencyInputFormatter = (value: any) => {
    let formattedValue = new Intl.NumberFormat(undefined).format(value);

    // const parts = formattedValue.split('.');
    // if (parts.length === 1) {
    //     formattedValue += '.00';
    // } else if (parts.length === 2 && parts[1].length === 1) {
    //     formattedValue += '0';
    // }

    return formattedValue;
};

export const currencyParser = (val: any) => {
    try {
        // Handle empty input
        if (typeof val === 'string' && !val.length) {
            val = '0.0';
        }

        // Detecting the grouping and decimal separators
        const group = new Intl.NumberFormat(undefined).format(1111).replace(/1/g, '');
        const decimal = new Intl.NumberFormat(undefined).format(1.1).replace(/1/g, '');

        // Replace group and decimal separators, convert comma to dot
        let reversedVal = val.replace(new RegExp('\\' + group, 'g'), '');
        reversedVal = reversedVal.replace(new RegExp('\\' + decimal, 'g'), '.');

        // Remove non-digit and non-dot characters
        reversedVal = reversedVal.replace(/[^0-9.]/g, '');

        // Handle digit appending
        const digitsAfterDecimalCount = (reversedVal.split('.')[1] || []).length;
        const needsDigitsAppended = digitsAfterDecimalCount > 2;

        if (needsDigitsAppended) {
            reversedVal = reversedVal * Math.pow(10, digitsAfterDecimalCount - 2);
        }

        // Convert the parsed value to a number, or 0 if it's not a number
        return Number.isNaN(reversedVal) ? 0 : reversedVal;
    } catch (error) {
        console.error(error);
    }
};
