import axiosInstance from '@/configs/service';
import { Member, UpdateMemberPasswordParams, UpdateMemberPhoneNumberParams, UpdateMemberProfileParams } from '@/types';

export const getMyProfile = () => {
    return axiosInstance.get<Member>('/member/my-profile');
};

export const updateMyProfile = (body: UpdateMemberProfileParams) => {
    return axiosInstance.put<Member>('/member/my-profile', body);
};

export const updateMyPassword = (password: UpdateMemberPasswordParams) => {
    return axiosInstance.put<Member>('/member/my-profile/password', password);
};

export const updateMyPhone = (phone: UpdateMemberPhoneNumberParams) => {
    return axiosInstance.put<Member>('/member/my-profile/phone-number', phone);
};
