import axiosInstance from '@/configs/service';
import { QuotationView, InvoiceBase, BookQuotation, BookInvoice, CompanyInformation } from '@/types';

export const getQuotationById = async () => {
    return axiosInstance.get<QuotationView>(`/public/bill/quotation/member`);
};

export const getInvoiceByBookTokenSubscriptionId = async (bookTokenSubscriptionId: string) => {
    return axiosInstance.get<InvoiceBase>(`/public/bill/invoice/${bookTokenSubscriptionId}`);
};

export const getBookQuotation = async () => {
    return axiosInstance.get<BookQuotation[]>(`/public/bill/quotation/member/book-order`);
};

export const getInvoiceByBookOrderId = async (bookOrderId: string) => {
    return axiosInstance.get<BookInvoice>(`/public/bill/invoice/${bookOrderId}/book-order`);
};
