import { FaInfoCircle } from 'react-icons/fa';
import { Card } from 'antd';
import { useTranslation } from 'next-i18next';

const PaymentAlert: React.FC = () => {
    const { t } = useTranslation(['dashboard']);
    return (
        <Card>
            <div className="flex flex-row items-center gap-6">
                <FaInfoCircle className="text-4xl text-blue-500" />
                <div className="text-base leading-loose">
                    <p className="text-xl font-bold text-[#262626]">{t('unlock-all-features-by-updating-your-subscription')}</p>
                    <p>{t('please-make-the-payment-and-send-the-receipt-to-staff-email-whatsapp')}</p>
                    <p>{t('our-team-will-verify-it-asap-thanks-for-your-cooperation')}</p>
                </div>
            </div>
        </Card>
    );
};

export default PaymentAlert;
