import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const studyRequestQuerySchema = Joi.object({
    name: Joi.string().allow(null, ''),
    bookName: Joi.string().allow(null, ''),
    email: Joi.string().trim().lowercase().allow(null, ''),
    phoneNumber: Joi.string().allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
    status: Joi.string().allow(null, ''),
}).concat(paginationSchema);
