import { AccountStatus } from '@prisma/client';
import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const memberQuerySchema = Joi.object({
    fullName: Joi.string().allow(null, ''),
    preferredName: Joi.string().allow(null, ''),
    email: Joi.string().trim().lowercase().allow(null, ''),
    phoneNumber: Joi.string().allow(null, ''),
    status: Joi.valid(AccountStatus.ACTIVE, AccountStatus.INACTIVE).optional().allow(null, ''),
    dateOfBirth: Joi.string().allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
}).concat(paginationSchema);

export const updateMemberProfileSchema = Joi.object({
    fullName: Joi.string().required(),
    preferredName: Joi.string().allow(null, ''),
    address: Joi.string().required(),
    dateOfBirth: Joi.string().required(),
    source: Joi.string().allow(null, ''),
    preferredLanguage: Joi.string().allow(null, ''),
    country: Joi.string().allow(null, ''),
    state: Joi.string().required(),
    city: Joi.string().allow(null, ''),
});

export const updateMemberEmailSchema = Joi.object({
    email: Joi.string().trim().lowercase().required(),
});

export const updateMemberPhoneNumberSchema = Joi.object({
    phoneNumber: Joi.string().required(),
});

export const updateMemberPasswordSchema = Joi.object({
    password: Joi.string().required(),
});
