import { Module } from '@nestjs/common';
import { MemberAuthModule } from 'src/member/auth/auth.module';
import { MediaModule } from 'src/media/media.module';
import { MemberController } from './member.controller';
import { MemberService } from './member.service';
import { MemberSharedModule } from 'src/member/member-shared.module';

@Module({
    imports: [MemberSharedModule, MemberAuthModule, MediaModule],
    exports: [MemberService],
    controllers: [MemberController],
    providers: [MemberService],
})
export class StaffMemberModule {}
