import { Controller, Get } from '@nestjs/common';
import { StaffDashboardService } from './dashboard.service';
import { User } from 'src/types';
import { Authenticator } from 'src/auth/auth.decorator';

@Controller()
export class StaffDashboardController {
    constructor(private dashboardService: StaffDashboardService) {}

    @Authenticator(User.STAFF)
    @Get('')
    async getDashboardStatistics() {
        return await this.dashboardService.getDashboardStatistics();
    }
}
