import { BookTokenSubscription, BookTokenSubscriptionStatus } from '@prisma/client';
import { Pagination } from 'src/types';

export interface BookTokenIdParam {
    bookTokenId: string;
}

export interface BookTokenQuery extends Pagination {
    refNo: string;
    memberName: string;
    packageName: string;
    status: BookTokenSubscriptionStatus;
    paymentDate: string[];
    createdAt: string[];
}

export interface BookTokenParams {
    refNo: string;
    memberName: string;
    packageName: string;
    status: BookTokenSubscriptionStatus;
    paymentDate: string[];
    createdAt: string[];
}

export type UpdateBookTokenDto = Pick<BookTokenSubscription, 'quantity' | 'paymentStatus' | 'expiredAt' | 'reason'> & {
    uploadFile: { mediaId: string }[];
};
