import { Body, Controller, Get, HttpCode, HttpStatus, Put } from '@nestjs/common';
import { Member, Authenticator } from 'src/auth/auth.decorator';
import { User } from 'src/types';
import { MemberInRequest } from 'src/types/member';
import { UpdateMyPasswordDto, UpdateMyPhoneNumberDto, UpdateMyProfileDto } from './my-profile.dto';
import { MemberMyProfileService } from './my-profile.service';

@Controller()
export class MemberMyProfileController {
    constructor(private memberService: MemberMyProfileService) {}

    @Authenticator(User.MEMBER)
    @Get('')
    @HttpCode(HttpStatus.OK)
    async getMyProfile(@Member() member: MemberInRequest) {
        const memberData = await this.memberService.getMyProfile(member.id);

        return memberData;
    }

    @Authenticator(User.MEMBER)
    @Put('')
    @HttpCode(HttpStatus.OK)
    async updateMyProfile(@Member() member: MemberInRequest, @Body() body: UpdateMyProfileDto) {
        const updatedMember = await this.memberService.updateMyProfile(member.id, body);
        return updatedMember;
    }

    @Authenticator(User.MEMBER)
    @Put('/phone-number')
    @HttpCode(HttpStatus.OK)
    async updateMyPhoneNumber(@Member() member: MemberInRequest, @Body() body: UpdateMyPhoneNumberDto) {
        const updatedMember = await this.memberService.updateMyPhoneNumber(member.id, body);
        return updatedMember;
    }

    @Authenticator(User.MEMBER)
    @Put('/password')
    @HttpCode(HttpStatus.OK)
    async updateMyPassword(@Member() member: MemberInRequest, @Body() body: UpdateMyPasswordDto) {
        const updatedMember = await this.memberService.updateMyPassword(member.id, body);
        return updatedMember;
    }
}
