import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const bookQuerySchema = Joi.object({
    name: Joi.string().allow(null, ''),
    description: Joi.string().allow(null, ''),
    createdAt: Joi.string().allow(null, ''),
}).concat(paginationSchema);

export const bookIdParamSchema = Joi.object({
    bookId: Joi.string().uuid().required(),
});
