import { Member } from '@prisma/client';

type MemberColumn = (keyof Member)[];

const memberColumn: MemberColumn = [
    'id',
    'fullName',
    'preferredName',
    'address',
    'email',
    'dateOfBirth',
    'password',
    'source',
    'status',
    'country',
    'state',
    'city',
    'preferredLanguage',
    'phoneNumber',
    'bookTokens',
    'createdAt',
    'updatedAt',
    'deletedAt',
];

const memberData = {
    exclude: (excludedColumns: MemberColumn) => {
        return memberColumn.filter((column) => !excludedColumns.includes(column));
    },
    getAll: memberColumn,
};

export default memberData;
