import { Injectable } from '@nestjs/common';
import { BookTokenSubscriptionStatus, MedicalCertificateStatus, Prisma } from '@prisma/client';
import { PrismaService } from 'src/prisma/prisma.service';

@Injectable()
export class DataService {
    constructor(private prisma: PrismaService) {}

    async getRoleData() {
        const roleResponse = await this.prisma.role.findMany({
            where: {
                deletedAt: null,
            },
            select: this.prisma.createSelect(['id', 'name']),
        });

        return roleResponse;
    }

    async getMemberData() {
        const memberResponse = await this.prisma.member.findMany({
            where: {
                deletedAt: null,
            },
            select: this.prisma.createSelect(['id', 'fullName', 'preferredName']),
        });

        return memberResponse;
    }

    async getMedicalCertificateData() {
        // Count medical certificate
        const medicalCertificateWhereOptions: Prisma.MedicalCertificateWhereInput = {
            status: MedicalCertificateStatus.PENDING,
            deletedAt: null,
        };

        const medicalCertificateCount = await this.prisma.medicalCertificate.count({
            where: medicalCertificateWhereOptions,
        });

        return medicalCertificateCount;
    }

    async getBookTokenRequestCount() {
        const bookTokenRequestCount = await this.prisma.bookTokenSubscription.count({
            where: {
                deletedAt: null,
                paymentStatus: BookTokenSubscriptionStatus.PENDING,
            },
        });

        return bookTokenRequestCount;
    }
}
