const isProduction = process.env.NODE_ENV === 'production';

// # Cookie Domain Configuration
export const DOMAIN = 'impactlifestudygroup.com';
export const COOKIE_DOMAIN = isProduction ? `.${DOMAIN}` : 'localhost';

export const USER_TOKEN_COOKIE_NAME = {
    staff: 'staff_token',
    member: 'member_token',
};

export const COOKIE_OPTIONS = {
    httpOnly: true,
    maxAge: 3 * 24 * 60 * 60 * 1000, // 3 days
    domain: COOKIE_DOMAIN,
};

// # URL Configuration
export const API_URL = isProduction ? 'https://api.impactlifestudygroup.com' : 'http://localhost:4000';
export const STAFF_URL = isProduction ? 'https://impactlifestudygroup.com' : 'http://localhost:3000';
export const MEMBER_URL = isProduction ? 'https://member.impactlifestudygroup.com' : 'http://localhost:3001';

export const IMAGE_QUALITY_REDUCED_BY_PERCENTAGE = 50;

// # Platform Configuration
export const PLATFORM_NAME = 'Impact Life Solutions';
