import { Dispatch, SetStateAction } from 'react';
import { AxiosError } from 'axios';
import { Staff } from './staff';

export interface ApiResponse<T = undefined> {
    success: boolean;
    message: string;
    data: T extends {} ? T : undefined;
    page?: number;
    total?: number;
}

export type ApiErrorResponse = {
    message: string;
    statusCode: number;
};

export type AxiosErrorResponse<T = undefined> = AxiosError<ApiErrorResponse & (T extends {} ? T : {})>;

export type BasePageProps = {
    staff: Staff;
};

export interface BaseModalProps {
    open: boolean;
    setOpen: Dispatch<SetStateAction<boolean>>;
}

export enum TokenType {
    CONFIRMATION = 'CONFIRMATION',
    RESET_PASSWORD = 'RESET_PASSWORD',
}

export interface ModalBaseProps {
    open: boolean;
    setOpen: Dispatch<SetStateAction<boolean>>;
}

export interface DebounceSelectInputValue {
    label: string;
    value: string;
}

export type Locales = 'en-GB' | 'zh-CN' | 'ms-MY';
