import { MediaResponse, MediaUploadResponse, PaginationParams } from '.';

export enum UploadType {
    LINK = 'LINK',
    FILE = 'FILE',
    NONE = 'NONE',
}

export enum BookStatus {
    ACTIVE = 'ACTIVE',
    INACTIVE = 'INACTIVE',
}

export interface BaseBook {
    id: string;
    name: string;
    link: string;
    uploadType?: UploadType;
    description: string;
    price: number;
    availableForBuy: boolean;
    remarks: string;
    createdAt: string;
    status: BookStatus;
    bookMedias: {
        media: MediaResponse;
    }[];
    bookImages: {
        media: MediaResponse;
    }[];
}

export interface BookWithLink extends BaseBook {
    link: string;
    uploadType: UploadType.LINK;
}

export interface BookWithFile extends BaseBook {
    uploadType: UploadType.FILE;
}

export type Book = BookWithLink | BookWithFile;

export interface BookUpdateParams {
    name: string;
    description: string;
    price: number;
    availableForBuy: boolean;
    uploadType: UploadType;
    link?: string;
    uploadFile: MediaUploadResponse[] | null;
    bookImages: MediaUploadResponse[];
}

export interface BookAddParams {
    name: string;
    description: string;
    price: number;
    uploadType: UploadType;
    link?: string;
    uploadFile: MediaUploadResponse[] | null;
    bookImages: MediaUploadResponse[];
}

export interface BookQuery extends PaginationParams {
    name?: string;
    createdAt?: string;
}
