import { Book, MediaFormValue, MediaResponse, Member } from '.';

export enum BookOrderStatus {
    PENDING = 'PENDING',
    PAID = 'PAID',
    UNPAID = 'UNPAID',
}

export interface BookOrder {
    id: string;
    displayId: string;
    memberId: string;
    bookId: string;
    bookPrice: number;
    quantity: number;
    status: BookOrderStatus;
    createdAt: string;
    updatedAt: string;
    book: Book;
    member: Member;
    media: {
        media: MediaResponse;
    }[];
}

export type BookOrderList = Pick<BookOrder, 'id' | 'displayId' | 'status' | 'quantity' | 'bookPrice' | 'book' | 'member'> &
    { length: number; status: string }[];

export type BookOrderDetails = Pick<BookOrder, 'id' | 'status' | 'bookPrice' | 'quantity' | 'displayId' | 'media' | 'book' | 'member'>;

export type UpdateBookOrderDetails = Pick<BookOrder, 'status' | 'quantity' | 'bookPrice' | 'member' | 'book'> & {
    uploadFile: MediaFormValue[];
};
