import { UploadFile } from 'antd';
import { MediaFormValue, MediaResponse, MediaUploadResponse } from '@/types';
import { mediaUrlGenerator } from '@/utils';


export const mediaResponseToFormValue = (data: {media: MediaResponse}): MediaFormValue => {
    const { media } = data
    return {
        uid: media.id,
        name: media.name,
        url: mediaUrlGenerator(media.key),
        status: 'done',
    };
};

export const mediaFormValueToResponse = (fileList: UploadFile<MediaFormValue> | MediaFormValue): MediaUploadResponse => {
    
    if ('response' in fileList) {
        return {
            mediaId: fileList.response?.uid || '',
        };
    }

    return {
        mediaId: fileList.uid,
    };
};
