import axiosInstance, { uploadInstance } from '@/configs/service';
import { CompanyInformation, MediaFormValue, MediaResponse, PaginationResponse, PenaltyAmount } from '@/types';
import { Package, PackageParams, PackageQuery } from '@/types/package';
import { mediaUrlGenerator } from '@/utils';

export const getPackageList = (query: PackageQuery) => {
    return axiosInstance.get<PaginationResponse<Package>>('staff/site-setting/package', { params: query });
};

export const addPackage = (body: PackageParams) => {
    return axiosInstance.post<Package>('staff/site-setting/package', body);
};

export const deletePackage = (packageId: string) => {
    return axiosInstance.delete<Package>(`staff/site-setting/package/${packageId}`);
};

export const updatePackage = (packageId: string, body: PackageParams) => {
    return axiosInstance.put<Package>(`staff/site-setting/package/${packageId}`, body);
};

export const getPenaltyAmount = () => {
    return axiosInstance.get<PenaltyAmount>('staff/site-setting/penalty-amount');
};

export const updatePenaltyAmount = (body: PenaltyAmount) => {
    return axiosInstance.put<PenaltyAmount>('staff/site-setting/penalty-amount', { penaltyAmount: body.penaltyAmount });
};

export const getCompanyInformation = () => {
    return axiosInstance.get<CompanyInformation>('staff/site-setting/company-information');
};

export const updateCompanyInformation = (body: CompanyInformation) => {
    return axiosInstance.put<CompanyInformation>('staff/site-setting/company-information', body);
};

export const uploadNoticeImage = async (url: string, option: any) => {
    const formData = new FormData();
    formData.append('file', option.file);

    try {
        const response = await uploadInstance.post<MediaResponse>(url, formData);

        option.onSuccess({
            uid: response.data.id,
            name: response.data.name,
            url: mediaUrlGenerator(response.data.key),
            status: 'done',
        } as MediaFormValue);
    } catch (error) {
        option.onError(error);
    }
};

export const getNotice = () => {
    return axiosInstance.get<{ jsonValue: JSON[] }[]>('staff/site-setting/notice');
};

export const updateNotice = (body: { value: string }) => {
    return axiosInstance.put('staff/site-setting/notice', body);
};
