import { CheckCircleOutlined, CloseCircleOutlined } from '@ant-design/icons';

interface PasswordHintProps {
    isFulfilled: boolean;
    passwordHint: string;
}

const PasswordHint: React.FC<PasswordHintProps> = ({ isFulfilled, passwordHint }) => {
    return (
        <div>
            {isFulfilled ? <CheckCircleOutlined className="text-green-500" /> : <CloseCircleOutlined className="text-red-500" />}
            <span className="ml-2">{passwordHint}</span>
        </div>
    );
};

export default PasswordHint;
