import { ReactNode } from 'react';
import { useTranslation } from 'next-i18next';
import { Button, Modal, Space } from 'antd';

interface SelectRoleConfirmationModalProps {
    open: boolean;
    onCancel: () => void;
    onUpdate: () => void;
    message: ReactNode | string;
}

const SelectRoleConfirmationModal: React.FC<SelectRoleConfirmationModalProps> = ({ open, message, onCancel, onUpdate }) => {
    const { t } = useTranslation(['staff', 'common']);

    return (
        <Modal width={400} open={open} footer={null} onCancel={onCancel} closeIcon={false} centered title={t('switch-role-confirmation')}>
            <Space direction="vertical" size="large" style={{ display: 'flex' }}>
                <p className="mt-2">{message}</p>
                <div className="flex justify-end gap-2">
                    <Button block onClick={onCancel}>
                        {t('common:cancel')}
                    </Button>
                    <Button block type="primary" onClick={onUpdate}>
                        {t('common:update')}
                    </Button>
                </div>
            </Space>
        </Modal>
    );
};

export default SelectRoleConfirmationModal;
