import { Checkbox, Form } from 'antd';

export interface RoleAction {
    actionName: string;
    actionFormName: string;
}

interface RoleCheckboxProps {
    roleAction: RoleAction;
}

const RoleCheckbox: React.FC<RoleCheckboxProps> = ({ roleAction }) => {
    return (
        <Form.Item initialValue={false} name={roleAction.actionFormName} className="!m-0" valuePropName="checked">
            <Checkbox>{roleAction.actionName}</Checkbox>
        </Form.Item>
    );
};

export default RoleCheckbox;
