import { BookTokenSubscriptionStatus } from '@/types/book-token';
import { Tag } from 'antd';
import { useTranslation } from 'next-i18next';

interface BookTokenStatusTagProps {
    status: BookTokenSubscriptionStatus;
}

const BookTokenStatusTag: React.FC<BookTokenStatusTagProps> = ({ status }) => {
    const { t } = useTranslation(['book-token', 'common', 'messages', 'layout']);

    switch (status) {
        case BookTokenSubscriptionStatus.PAID:
            return <Tag color="green">{t('paid')}</Tag>;
        case BookTokenSubscriptionStatus.UNPAID:
            return <Tag color="orange">{t('unpaid')}</Tag>;
        case BookTokenSubscriptionStatus.PENDING:
            return <Tag color="blue">{t('pending')}</Tag>;
        case BookTokenSubscriptionStatus.REJECTED:
            return <Tag color="red">{t('rejected')}</Tag>;
    }
};

export default BookTokenStatusTag;
