import { CloudDownloadOutlined } from '@ant-design/icons';
import { Button } from 'antd';
import { useTranslation } from 'next-i18next';
import ExcelJS from 'exceljs';

// PDF
interface ExportDataProps {
    getExportData: () => Promise<{ data: any }>;
}

const ExportData: React.FC<ExportDataProps> = ({ getExportData }) => {
    const { t } = useTranslation(['book-order', 'layout', 'common', 'messages']);

    const workbook = new ExcelJS.Workbook();
    const worksheet = workbook.addWorksheet('Book Orders');

    // Columns
    worksheet.columns = [
        { header: 'Ref No', key: 'refNo', width: 20 },
        { header: 'Member', key: 'member', width: 20 },
        { header: 'Address', key: 'address', width: 40 },
        { header: 'Phone Number', key: 'phoneNumber', width: 20 },
        { header: 'Book', key: 'book', width: 20 },
        { header: 'Price', key: 'price', width: 20 },
        { header: 'Quantity', key: 'quantity', width: 5 },
        { header: 'Payment Status', key: 'paymentStatus', width: 20 },
        { header: 'Created At', key: 'createdAt', width: 20 },
    ];

    // Add Row Style
    worksheet.getRow(1).font = { bold: true };
    worksheet.getRow(1).alignment = { horizontal: 'center' };
    worksheet.getRow(1).fill = {
        type: 'pattern',
        pattern: 'solid',
        fgColor: { argb: 'FFA9A9A9' },
    };

    const generateExcelHandler = async (data: any) => {
        data?.map((order: any) => {
            worksheet.addRow({
                book: order.bookName,
                price: order.bookPrice,
                quantity: order.bookQuantity,
                createdAt: order.createdAt,
                refNo: order.refNo,
                member: order.memberName,
                address: order.memberAddress,
                phoneNumber: `;${order.memberPhone}`,
                paymentStatus: order.paymentStatus,
            });
        });

        // Generate the Excel file
        await workbook.xlsx.writeBuffer().then((buffer: any) => {
            const blob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
            const link = document.createElement('a');
            const url = URL.createObjectURL(blob);
            link.href = url;
            link.setAttribute('download', `book-order.csv`);
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    };

    const exportToCsvHandler = () => {
        getExportData().then((res) => {
            generateExcelHandler(res.data);
        });
    };

    return (
        <Button type="primary" icon={<CloudDownloadOutlined />} onClick={exportToCsvHandler}>
            {t('export-csv')}
        </Button>
    );
};

export default ExportData;
