import DOMPurify from 'dompurify';
import { Interweave } from 'interweave';

interface HtmlParserProps {
    html: string;
    className?: string;
}

const HtmlParser: React.FC<HtmlParserProps> = ({ html, className }) => {
    const purifiedHtml = DOMPurify.sanitize(html);
    return <Interweave className={className} content={purifiedHtml} />;
};

export default HtmlParser;
