import axiosInstance, { uploadInstance } from '@/configs/service';
import { MediaFormValue, MediaResponse, PaginationParams, PaginationResponse, SortOrder } from '@/types';
import { BookTokenSubscriptionList, RequestBookTokenPayload, UploadProofOfPaymentPayload } from '@/types/book-token';
import { mediaUrlGenerator } from '@/utils';

export const bookTokenKeys = {
    pagination: (pagination: PaginationParams = { page: 1, pageSize: 10, sortField: 'createdAt', sortOrder: SortOrder.DESC }) => [
        'book-token-subscription',
        'pagination',
        pagination,
    ],
    id: (id: string) => ['book-token-subscription', id],
};

export const getBookTokenSubscriptionList = (query: PaginationParams) => {
    return axiosInstance.get<PaginationResponse<BookTokenSubscriptionList>>('/member/book-token', { params: query });
};

export const getBookTokenSubscriptionById = (id: string) => {
    return axiosInstance.get<BookTokenSubscriptionList>(`/staff/book-token/${id}`);
};

export const requestBookToken = (data: RequestBookTokenPayload) => {
    return axiosInstance.post('/member/book-token', data);
};

export const cancelRequestBookToken = (bookTokenSubscriptionId: string) => {
    return axiosInstance.delete(`/member/book-token/${bookTokenSubscriptionId}`);
};

export const uploadProofMedia = async (url: string, option: any) => {
    const formData = new FormData();
    formData.append('file', option.file);

    try {
        const response = await uploadInstance.post<MediaResponse>(url, formData);

        option.onSuccess({
            uid: response.data.id,
            name: response.data.name,
            url: mediaUrlGenerator(response.data.key),
            status: 'done',
        } as MediaFormValue);
    } catch (error) {
        option.onError(error);
    }
};

export const uploadProofOfPayment = async (bookTokenSubscriptionId: string, data: UploadProofOfPaymentPayload) => {
    return axiosInstance.post(`/member/book-token/${bookTokenSubscriptionId}`, data);
};
