import axiosInstance, { uploadInstance } from '@/configs/service';
import { MediaFormValue, MediaResponse, PaginationParams, PaginationResponse } from '@/types';
import { BookOrderDetails, BookOrderList, OrderBookParams, UpdateBookOrderDetails } from '@/types/book-order';
import { mediaUrlGenerator } from '@/utils';

export const getBookOrderList = (query: PaginationParams) => {
    return axiosInstance.get<PaginationResponse<BookOrderList>>('/member/book-order', { params: query });
};

export const getBookOrderById = (bookOrderId: string) => {
    return axiosInstance.get<BookOrderDetails>(`/member/book-order/${bookOrderId}`);
};

export const orderBook = (data: OrderBookParams) => {
    return axiosInstance.post('/member/book-order', data);
};

export const updateBookOrderById = (bookOrderId: string, body: UpdateBookOrderDetails) => {
    return axiosInstance.put(`/member/book-order/${bookOrderId}`, body);
};

export const uploadBookOrderMedia = async (url: string, option: any) => {
    const formData = new FormData();
    formData.append('file', option.file);

    try {
        const response = await uploadInstance.post<MediaResponse>(url, formData);

        option.onSuccess({
            uid: response.data.id,
            name: response.data.name,
            url: mediaUrlGenerator(response.data.key),
            status: 'done',
        } as MediaFormValue);
    } catch (error) {
        option.onError(error);
    }
};

export const cancelBookOrderById = (bookOrderId: string) => {
    return axiosInstance.delete(`/member/book-order/${bookOrderId}`);
};
