import {
    Dispatch,
    PropsWithChildren,
    SetStateAction,
    createContext,
    useContext,
    useState,
} from "react";
import { Member } from "@/types";

export type MemberContextType = {
    member: Member | null;
    setMember: Dispatch<SetStateAction<Member | null>>;
};

const MemberContext = createContext<MemberContextType>({
    member: null,
    setMember: () => void 0,
});

type MemberProviderProps = PropsWithChildren;

const MemberProvider = ({ children }: MemberProviderProps) => {
    const [member, setMember] = useState<Member | null>(null);

    return (
        <MemberContext.Provider value={{ member, setMember }}>
            {children}
        </MemberContext.Provider>
    );
};

export default MemberProvider;

export const useMemberContext = () => {
    const context = useContext(MemberContext);

    if (!context) {
        throw new Error(
            "useMemberContext must be used within a MemberProvider"
        );
    }

    return context;
};
