import { Member, StudyBookRequestStatus, StudyGroupStatus } from '@prisma/client';
import { Pagination } from './pagination';
import { BaseBook } from '.';

// Study Group
export interface StudyGroup extends Pagination {
    id: string;
    bookId: string;
    bookName: string;
    name: string;
    status: StudyGroupStatus;
    startDate: string;
    endDate: string;
    description: string;
    createdAt: string;
    updatedAt: string;
    book: BaseBook;
    studyGroupTask: StudyGroupTask[];
    studyGroupMember: StudyGroupMember[];
}

// Study Group Member
export interface StudyGroupMember {
    memberId: string;
    studyGroupId: string;
    createdAt: string;
    updatedAt: string;
    studyGroup: StudyGroup;
    member: Member;
}

export interface StudyGroupMembers extends Pagination {
    name: string;
    phoneNumber: string;
}

// Study Group Task
export interface StudyGroupTask {
    id: string;
    studyGroupId: string;
    description: string;
    startDate: string;
    endDate: string;
    status: boolean;
    createdAt: string;
    updatedAt: string;
    studyGroup: StudyGroup;
    studyGroupTaskComment: StudyGroupTaskComment[];
    penalties: Penalty[];
}

export interface StudyGroupTaskComment {
    id: string;
    studyGroupTaskId: string;
    memberId: string;
    comment: string;
    createdAt: string;
    updatedAt: string;
    studyGroupTask: StudyGroupTask;
    member: Member;
}

export interface StudyGroupTaskCommentFilter extends Pagination {
    name: string;
}

// Penalty
export interface Penalty {
    id: string;
    memberId: string;
    studyGroupTaskId: string;
    amount: number;
    createdAt: string;
    updatedAt: string;
    member: Member;
    studyGroupTask: StudyGroupTask;
}

export interface StudyGroupQuery {
    selectGroupName: string;
    enterGroupName: string;
    groupPeriod: string;
}

export interface StudyRequestQuery extends Pagination {
    name: string;
    bookName: string;
    email: string;
    phoneNumber: string;
    createdAt: string[];
    status: StudyBookRequestStatus;
}

export interface TotalPenalty {
    member: {
        id: string;
        fullName: string;
        phoneNumber: string;
    };
    amount: number;
    studyGroupTask: {
        taskDate: Date;
    };
}

export type TotalPenaltyByStudyGroup = TotalPenalty;
export type TotalPenaltyBySubTasks = TotalPenalty;
