import { permissions } from 'src/data/role';

export interface Media {
    fieldname: string;
    originalname: string;
    encoding: string;
    mimetype: string;
    buffer: Buffer;
    size: number;
}

export interface UploadOptions {
    isPublic?: boolean;
    referenceTable?: string;
    referenceId?: string;
    permission?: (typeof permissions)[number];
    uploadedBy?: string;
    userId?: string;
}

export interface MediaResponse {
    mediaId: string;
    key: string;
    name: string;
    type: string;
}

export interface MediaUploadParam {
    mediaId: string;
}
