import { MediaResponse } from '.';

export enum UploadType {
    LINK = 'LINK',
    FILE = 'FILE',
    NONE = 'NONE',
}

export type AddBookWithLink = {
    name: string;
    description: string;
    price: number;
    uploadType: UploadType.LINK;
    link: string;
    uploadFile: {
        mediaId: string;
    }[];
};

export type AddBookWithFile = {
    name: string;
    description: string;
    price: number;
    uploadType: UploadType.FILE;
    uploadFile: {
        mediaId: string;
    }[];
};

export type AddBookWithNone = {
    name: string;
    description: string;
    price: number;
    uploadType: UploadType.NONE;
    uploadFile: {
        mediaId: string;
    }[];
};

export type UpdateBookWithLink = {
    name: string;
    description: string;
    price: number;
    availableForBuy: boolean;
    uploadType: UploadType.LINK;
    remarks: string;
    link: string;
    uploadFile: {
        mediaId: string;
    }[];
};

export type UpdateBookWithFile = {
    name: string;
    description: string;
    price: number;
    availableForBuy: boolean;
    uploadType: UploadType.FILE;
    remarks: string;
    uploadFile: {
        mediaId: string;
    }[];
};

export type UpdateBookWithNone = {
    name: string;
    description: string;
    price: number;
    availableForBuy: boolean;
    uploadType: UploadType.NONE;
    remarks: string;
    uploadFile: {
        mediaId: string;
    }[];
};

export interface BaseBook {
    id: string;
    name: string;
    link: string;
    description: string;
    createdAt: string;
    bookMedias: {
        media: MediaResponse;
    }[];
}
