import { Request } from 'express';
import { StaffInRequest } from './staff';
import { MemberInRequest } from './member';

export enum User {
    STAFF = 'STAFF',
    MEMBER = 'MEMBER',
}

export type Token = string | undefined;

export interface RequestWithStaff extends Request {
    staff: StaffInRequest;
}

export interface RequestWithMember extends Request {
    member: MemberInRequest;
}

export interface MemberJwtPayload {
    id: string;
    email: string;
    fullName: string;
}

export interface StaffJwtPayload {
    id: string;
    email: string;
    fullName: string;
}
