export interface StudyGroupTaskWithSubTask {
    studyGroupTaskId: string;
    name: string;
    description: string;
    startDate: string;
    endDate: string;
    status: boolean;
    subTasks: {
        id: string;
        date: string;
        commentCount: number;
        penaltyAmount: number;
    }[];
}

interface InputData {
    id: string;
    status: boolean;
    name: string;
    startDate: Date;
    endDate: Date;
    description: string;
    studyGroupSubTask: {
        id: string;
        penalties: {
            amount: number;
        }[];
        _count: {
            studyGroupTaskComment: number;
        };
        date: Date;
    }[];
}
export const studyGroupTaskWithSubTaskTransformer = (data: InputData) => {
    const { studyGroupSubTask } = data;

    const body: StudyGroupTaskWithSubTask = {
        studyGroupTaskId: data.id,
        name: data.name,
        description: data.description,
        startDate: data.startDate.toISOString(),
        endDate: data.endDate.toISOString(),
        status: data.status,
        subTasks: studyGroupSubTask.map((subTask) => {
            return {
                id: subTask.id,
                date: subTask.date.toISOString(),
                commentCount: subTask._count.studyGroupTaskComment,
                penaltyAmount: subTask.penalties.reduce((total, penaltyAmount) => {
                    return total + penaltyAmount.amount;
                }, 0),
            };
        }),
    };

    return body;
};
