import { PackageStatus } from '@prisma/client';
import { Pagination } from 'src/types';

export interface PackageQuery extends Pagination {
    name: string;
    status: PackageStatus;
}

export interface PackageDto {
    name: string;
    price: number;
    status: PackageStatus;
    numberOfBookToken: number;
    description: string;
}

export interface PenaltyDto {
    penaltyAmount: number;
}

export interface UpdateCompanyInformationDto {
    address: string;
    contactNumber: string;
    bankName: string;
    accountNumber: string;
    accountHolderName: string;
}
