import { Injectable } from '@nestjs/common';
import * as argon from 'argon2';
import { PrismaService } from 'src/prisma/prisma.service';

@Injectable()
export class MyProfileService {
    constructor(private readonly prisma: PrismaService) {}

    async updateMyPassword(staffId: string, password: string) {
        const hashedPassword = await argon.hash(password);
        const staffData = await this.prisma.staff.update({
            where: {
                id: staffId,
            },
            data: {
                password: hashedPassword,
            },
            select: {
                id: true,
            },
        });

        return staffData;
    }
}
