import { BookStatus } from '@prisma/client';
import { AddBookWithFile, AddBookWithLink, AddBookWithNone, Pagination, UpdateBookWithFile, UpdateBookWithLink, UpdateBookWithNone } from 'src/types';

export type AddBookDto = (AddBookWithLink | AddBookWithFile | AddBookWithNone) & { bookImages: { mediaId: string }[] };
export type UpdateBookDto = (UpdateBookWithLink | UpdateBookWithFile | UpdateBookWithNone) & { bookImages: { mediaId: string }[] };

export interface BookQuery extends Pagination {
    name: string;
    status: BookStatus;
    createdAt: string[];
}

export interface BookIdParam {
    bookId: string;
}
