import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const bookOrderQuerySchema = Joi.object({
    refNo: Joi.string().allow(null, ''),
    memberName: Joi.string().allow(null, ''),
    bookName: Joi.string().allow(null, ''),
    status: Joi.string().allow(null, ''),
}).concat(paginationSchema);

export const createBookOrderSchema = Joi.object({
    bookId: Joi.string().uuid().required(),
    memberId: Joi.string().uuid().required(),
    quantity: Joi.number().required(),
});

export const updateBookOrderSchema = Joi.object({
    quantity: Joi.number().required(),
    bookPrice: Joi.number().required(),
    status: Joi.string().required(),
    media: Joi.array()
        .items(Joi.object({ mediaId: Joi.string().uuid().required() }))
        .required(),
});
