import { Injectable } from '@nestjs/common';
import { PrismaService } from 'src/prisma/prisma.service';

@Injectable()
export class CompanyInfoService {
    constructor(private prisma: PrismaService) {}

    async getSupport() {
        const response = await this.prisma.metaData.findFirst({
            where: {
                key: 'company-information',
            },
            select: {
                value: true,
            },
        });

        return response.value;
    }
}
