import { Body, Controller, HttpCode, HttpStatus, Post } from '@nestjs/common';
import { MemberService } from './member.service';
import { Member } from '@prisma/client';

@Controller()
export class MemberController {
    constructor(private memberService: MemberService) {}

    @Post('register')
    @HttpCode(HttpStatus.OK)
    async register(@Body() body: Member) {
        const response = this.memberService.registerMember(body);

        return response;
    }
}
