import { Injectable } from '@nestjs/common';
import { PackageStatus, StudyGroupStatus } from '@prisma/client';
import * as dayjs from 'dayjs';
import { PrismaService } from 'src/prisma/prisma.service';

@Injectable()
export class MemberDataService {
    constructor(private readonly prisma: PrismaService) {}

    async getPackageList() {
        return await this.prisma.package.findMany({
            where: {
                deletedAt: null,
                status: PackageStatus.ACTIVE,
            },
            select: {
                id: true,
                name: true,
                price: true,
                numberOfBookToken: true,
                description: true,
                status: true,
            },
        });
    }

    async getSupport() {
        const response = await this.prisma.metaData.findFirst({
            where: {
                key: 'company-information',
            },
            select: {
                value: true,
            },
        });

        return response.value;
    }

    async getNotice() {
        const websiteContent = await this.prisma.metaData.findMany({
            where: {
                key: 'notices',
            },
        });

        return websiteContent;
    }

    async getUncommentedTasks(memberId: string) {
        const tasks = await this.prisma.studyGroupTask.findMany({
            where: {
                taskDate: dayjs().startOf('day').toDate(),
                studyGroup: {
                    status: StudyGroupStatus.ONGOING,
                    deletedAt: null,
                    studyGroupMembers: {
                        some: {
                            memberId,
                        },
                    },
                },
                deletedAt: null,
            },
            select: {
                id: true,
                studyGroup: {
                    select: {
                        id: true,
                        name: true,
                    },
                },
            },
        });

        return tasks;
    }
}
