import * as Joi from 'joi';

export const bookTokenSubscriptionIdSchema = Joi.object({
    bookTokenSubscriptionId: Joi.string().required(),
});

export const bookTokenIdSchema = Joi.object({
    bookTokenId: Joi.string().required(),
});

export const requestBookTokenSchema = Joi.object({
    selectedPackage: Joi.string().uuid().required(),
    unitPrice: Joi.number().required(),
    quantity: Joi.number().required(),
    totalAmount: Joi.number().required(),
});

export const uploadProofOfPaymentSchema = Joi.object({
    paymentDate: Joi.date().required(),
    medias: Joi.array()
        .items(Joi.object({ mediaId: Joi.string().required() }).required())
        .required(),
});
