import { Staff } from '@prisma/client';

type StaffColumn = (keyof Staff)[];

const staffColumn: StaffColumn = ['id', 'fullName', 'email', 'password', 'roleId', 'status', 'phoneNumber', 'createdAt', 'updatedAt', 'deletedAt'];

const staffData = {
    exclude: (excludedColumns: StaffColumn) => {
        return staffColumn.filter((column) => !excludedColumns.includes(column));
    },
    getAll: staffColumn,
};

export default staffData;
