import { SortOrder as AntdSortOrder } from 'antd/es/table/interface';

export enum SortOrder {
    ASC = 'asc',
    DESC = 'desc',
}

export interface PaginationParams {
    page: number;
    pageSize: number;
    sortField: string;
    sortOrder: SortOrder;
}

export interface PaginationState extends PaginationParams {
    total: number;
}

export interface PaginationResponse<T> {
    current: number;
    page: number;
    total: number;
    rows: T[];
}

export interface Sorter {
    field: string | undefined;
    order: AntdSortOrder;
}

// Combine the required sort parameters and optional parameters
export type UsePaginationParams = Partial<PaginationParams>;
