import { MediaResponse, PaginationParams, StudyGroupMember, TokenType } from '.';
import { Role } from './role';

export enum MemberStatus {
    ACTIVE = 'ACTIVE',
    INACTIVE = 'INACTIVE',
}

interface MemberToken {
    staffId: string;
    type: TokenType;
    token: string;
    expiredAt: string;
    createdAt: string;
    updatedAt: string;
    usedAt?: string;
}

export interface Member {
    id: string;
    fullName: string;
    preferredName: string;
    phoneNumber: string;
    address: string;
    email: string;
    dateOfBirth: string;
    password: string;
    status: MemberStatus;
    country: string;
    city: string;
    state: string;
    roleId: string;
    role: Role;
    isPaid: boolean;
    tokens: MemberToken[];
    studyGroupMembers: StudyGroupMember[];
    lastActive: string;
    createdAt: string;
    updatedAt: string;
}

export interface MemberQuery extends PaginationParams {
    fullName: string;
    email: string;
    phoneNumber: string;
    status: MemberStatus;
    dateOfBirth: string;
    createdAt: string;
}

export interface CreateMemberParams {
    email: string;
    fullName: string;
    preferredName: string;
    phoneNumber: string;
    address: string;
    dateOfBirth: string;
}

export interface UpdateMemberProfileParams {
    fullName: string;
    address: string;
    dateOfBirth: string;
    country: string;
    city: string;
    state: string;
}

export interface UpdateMemberEmailParams {
    email: string;
}

export interface UpdateMemberPhoneNumberParams {
    phoneNumber: string;
}

export interface UpdateMemberPasswordParams {
    password: string;
}

export interface MemberDebounce {
    disabled: undefined;
    key: string;
    label: string;
    title: undefined;
    value: string;
}
export interface MemberSubscriptionResponse {
    memberId: string;
    media: MediaResponse;
}
