import { MediaFormValue, MediaResponse } from './media';
import { Member } from './member';
import { Package } from './package';

export enum BookTokenSubscriptionStatus {
    PENDING = 'PENDING',
    PAID = 'PAID',
    UNPAID = 'UNPAID',
    REJECTED = 'REJECTED',
}

export interface BookTokenSubscription {
    id: string;
    memberId: string;
    displayId: string;
    price: number;
    paymentDate: string;
    numberOfBookTokens: number;
    quantity: number;
    paymentStatus: BookTokenSubscriptionStatus;
    reason?: string;
    expiredAt?: Date;
    createdAt: string;
    bookTokenSubscriptionMedias: {
        media: MediaResponse;
    }[];
    member: Pick<Member, 'id' | 'fullName' | 'address' | 'phoneNumber'>;
    package: Package;
}

export interface RequestBookTokenPayload {
    numberOfBookTokens: number;
}

export interface BookTokenRequestParams {
    refNo: string;
    memberName: string;
    packageName: string;
    status: string;
}

export type BookTokenSubscriptionList = Pick<
    BookTokenSubscription,
    'id' | 'paymentStatus' | 'reason' | 'price' | 'quantity' | 'numberOfBookTokens' | 'displayId' | 'expiredAt' | 'member' | 'package'
>;

export type UploadProofOfPaymentPayload = Pick<BookTokenSubscription, 'paymentDate'> & { medias: { mediaId: string }[] };
export type BookTokenDetails = Pick<
    BookTokenSubscription,
    'id' | 'paymentStatus' | 'reason' | 'price' | 'expiredAt' | 'displayId' | 'numberOfBookTokens' | 'bookTokenSubscriptionMedias' | 'package'
>;
export type UpdateBookTokenDetails = Pick<BookTokenSubscription, 'paymentStatus' | 'reason' | 'quantity' | 'expiredAt'> & {
    package: string;
    uploadFile: MediaFormValue[];
};
